
*## Pre-simulation running-forward of recursively-dynamic CGE model (over pre-simulation period 2014-2021 (tp))
*## "presim.g00" work-file saved for subsequent dynamically-recursive counterfactual and policy scenario simulations (over simulation period 2021-2040 (ts))

PARAMETER TARGETS_SIM(NMACRO_AGG,t1)    Nominal Macro Aggregates for Pre-simulation Targeting
;

$libinclude xlimport TARGETS_SIM IndiaData2014.xlsx TARGETS_SIM

TARGETS_SIM(NMACRO_AGG,tp) = TARGETS_SIM(NMACRO_AGG,tp);

*Use GDP deflator as price numeraire (it will be allowed to vary to target nominal GDP below)
 GDPDEF.FX = GDPDEF0;
 CPI.LO = -inf;
 CPI.UP = +inf;


loop(t1$tp(t1),

IF(ORD(t1) gt 1,
*Use final week solution from previous year as initial week value for new year
S_TB.FX(h,t1_tb)$(ord(t1_tb) eq 1) = SUM(t1_tbp$(ord(t1_tbp) eq card(t1_tbpp)),S_TB.L(h,t1_tbp)) ;
L_TB.FX(h,t1_tb)$(ord(t1_tb) eq 1) = SUM(t1_tbp$(ord(t1_tbp) eq card(t1_tbpp)),L_TB.L(h,t1_tbp)) ;
I_TB.FX(h,t1_tb)$(ord(t1_tb) eq 1) = SUM(t1_tbp$(ord(t1_tbp) eq card(t1_tbpp)),I_TB.L(h,t1_tbp)) ;
Ir_TB.FX(h,t1_tb)$(ord(t1_tb) eq 1) = SUM(t1_tbp$(ord(t1_tbp) eq card(t1_tbpp)),Ir_TB.L(h,t1_tbp)) ;
T_TB.FX(h,t1_tb)$(ord(t1_tb) eq 1) = SUM(t1_tbp$(ord(t1_tbp) eq card(t1_tbpp)),T_TB.L(h,t1_tbp)) ;
Tr_TB.FX(h,t1_tb)$(ord(t1_tb) eq 1) = SUM(t1_tbp$(ord(t1_tbp) eq card(t1_tbpp)),Tr_TB.L(h,t1_tbp)) ;

*Use Balanced Macro Closure
 GADJ.LO     = -inf;
 GADJ.UP     = +inf;
 GOVSHR.FX   = GOVSHR0 ;

*Fix Nominal GDP + release GDP deflator (price numeraire)
 GDPDEF.LO = -inf;
 GDPDEF.UP = +inf;
 NGDP.FX   = TARGETS_SIM('NGDP',t1) ;

*Fix Real GDP + release (avg.) Total Factor Productivity parameter
 TFPadj.LO = -inf;
 TFPadj.UP = +inf;
 RGDP.FX   = TARGETS_SIM('RGDP',t1) ;

);


 SOLVE STANDCGE_TB USING MCP ;


*Calculate change in low BMI risk factor
RISKfact_prev.FX('r03',h) = SUM(PersonID$(((DHSdata0(h,PersonID,'Weight')+(365*(QHnut_cap_day_final.L(H)-QHnut_cap_day_final0(H))/7715))/POWER(DHSdata0(h,PersonID,'Height')/100,2))<18.5),1)/card(PersonID);

 display 'here is walras', WALRAS.L, NGDP.L, RGDP.L, NCG.L, NINV.L, NEXP.L, NIMP.L, EXR.L, FSAV.L, CPI_H.L, QH.L, QFS.L, TFPadj.L;

* Calculate demographic module impacts (modDEMOG.inc)
$batinclude modDEMOG.inc

 display 'here are demographics', BIRTHS, DEATHS, IntlMIGR, POP;

*Retain time-specific output variables in output parameters
$include output_cal_s.inc
$include output_s.inc

IF(ORD(t1) lt card(tp),
 QFH.FX(h,flnd) = QFH0(h,flnd);
 QFH.FX(h,flab) = SKLshr0(h,flab)*SUM((genp,age5p),part_rate(genp,age5p)*POP(h,genp,age5p,t1+1));
 QFH.FX(insd,fcap) = QFH.L(insd,fcap)*(1-DPR) + QFHshr(insd,fcap)*(SUM(C, PQ.L(C)*QINV.L(C))/IPI.L)/INVscale;
);

);

*Return to standard macro closure
 NGDP.LO   = -inf;
 NGDP.UP   = +inf;
 GDPDEF.FX = GDPDEF.L ;

 RGDP.LO   = -inf;
 RGDP.UP   = +inf;
 TFPadj.FX = TFPadj.L;
*$ontext
 NCG.LO    = -inf;
 NCG.UP    = +inf;
 GADJ.FX   = GADJ.L ;

 mps01(INSDNG) = 1;
 NINV.LO   = -inf;
 NINV.UP   = +inf;
 DMPS.FX   = DMPS0;
 MPSADJ.FX = MPSADJ.L ;

 NEXP.LO   = -inf;
 NEXP.UP   = +inf;
 DELTATadj.FX = DELTATadj.L;

 NIMP.LO   = -inf;
 NIMP.UP   = +inf;
 DELTAQadj.FX = DELTAQadj.L;

 EXR.LO    = -inf;
 EXR.UP    = +inf;
 FSAV.FX   = FSAV.L;

 GSAV.LO   = -inf;
 GSAV.UP   = +inf;
 GOVSHR.LO = -inf;
 GOVSHR.UP = +inf;
 GADJ.FX = GADJ.L ;

